<?php
// Define a fixed 10-digit code (stored in the script)
$fixed_code = '1234567890';

// Function to encrypt content using AES encryption
function encryptContent($content, $pin, $key) {
    $iv = random_bytes(openssl_cipher_iv_length('aes-256-cbc'));
    $encrypted_content = openssl_encrypt($content, 'aes-256-cbc', $key, 0, $iv);
    $encrypted_pin = openssl_encrypt($pin, 'aes-256-cbc', $key, 0, $iv);
    return base64_encode($encrypted_content . '::' . bin2hex($iv) . '::' . base64_encode($encrypted_pin));
}

// Function to decrypt content and PIN using AES encryption
function decryptContent($encrypted_data, $key) {
    list($encrypted_content, $iv, $encrypted_pin) = explode('::', base64_decode($encrypted_data), 3);
    $iv = hex2bin($iv);
    $content = openssl_decrypt($encrypted_content, 'aes-256-cbc', $key, 0, $iv);
    $pin = openssl_decrypt(base64_decode($encrypted_pin), 'aes-256-cbc', $key, 0, $iv);
    return ['content' => $content, 'pin' => $pin];
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Sanitize and fetch form data
    $content = htmlspecialchars($_POST['content']);
    $expiry_date = $_POST['expiry_date'];
    $pin = $_POST['pin'] ?? null;

    // Use the fixed 10-digit code as the encryption key
    $key = hash('sha256', $fixed_code);

    // Encrypt the content and PIN
    $encrypted_data = encryptContent($content, $pin, $key);

    // Set the expiry timestamp
    $expiry_timestamp = strtotime($expiry_date);

    // Generate a secure link with the encrypted content
    $secure_link = "view.php?data=" . urlencode($encrypted_data) . "&expiry=$expiry_timestamp";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Secure Link</title>
    <style>
        body {
            font-family: Calibri, sans-serif;
            background-color: #f7f8fa;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 100%;
            max-width: 600px;
            margin: 50px auto;
            padding: 30px;
            background-color: white;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            box-sizing: border-box;
        }
        h1 {
            text-align: center;
            color: #333;
        }
        form {
            display: flex;
            flex-direction: column;
        }
        label {
            margin-bottom: 8px;
            font-weight: bold;
            color: #333;
        }
        input[type="text"], input[type="date"], input[type="password"], textarea {
            padding: 12px;
            margin-bottom: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
            box-sizing: border-box;
            width: 100%;
        }
        button {
            padding: 12px 20px;
            background-color: #4CAF50;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s ease;
        }
        button:hover {
            background-color: #45a049;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 14px;
            color: #888;
        }
        .link-container {
            text-align: center;
            margin-top: 50px;
        }
        .secure-link {
            color: #3498db;
            text-decoration: none;
            font-weight: bold;
            font-size: 16px;
        }
        .secure-link:hover {
            text-decoration: underline;
        }
        .container h2 {
            color: #333;
            font-size: 24px;
        }
        textarea {
            resize: vertical;
            height: 150px;
        }
    </style>
</head>
<body>

<div class="container">
    <h1>Create a Secure Link</h1>

    <?php if ($_SERVER['REQUEST_METHOD'] == 'POST') { ?>
        <div class="link-container">
            <h2>Secue Link Created</h2>
            <p>Your secure link has been generated successfully:</p>
            <a href="<?php echo $secure_link; ?>" class="secure-link">Your Secure Link</a>
        </div>
    <?php } else { ?>
        <form method="POST">
            <label for="content">Paste your content:</label>
            <textarea name="content" id="content" required></textarea>

            <label for="expiry_date">Set expiry date:</label>
            <input type="date" name="expiry_date" id="expiry_date" required>

            <label for="pin">Set a 4-digit PIN (Optional):</label>
            <input type="password" name="pin" id="pin" maxlength="4" pattern="\d{4}" placeholder="4-digit PIN" />

            <button type="submit">Generate Secure Link</button>
        </form>
    <?php } ?>
</div>

<div class="footer">
    <p>&copy; 2024 SecureLink Generator</p>
</div>

</body>
</html>