<?php
// Define a fixed 10-digit code (stored in the script)
$fixed_code = '1234567890';

// Function to decrypt content and PIN using AES encryption
function decryptContent($encrypted_data, $key) {
    list($encrypted_content, $iv, $encrypted_pin) = explode('::', base64_decode($encrypted_data), 3);
    $iv = hex2bin($iv);
    $content = openssl_decrypt($encrypted_content, 'aes-256-cbc', $key, 0, $iv);
    $pin = openssl_decrypt(base64_decode($encrypted_pin), 'aes-256-cbc', $key, 0, $iv);
    return ['content' => $content, 'pin' => $pin];
}

// Handle the link and decryption process
if (isset($_GET['data'], $_GET['expiry'])) {
    $encrypted_data = $_GET['data'];
    $expiry_timestamp = $_GET['expiry'];

    // Check if the link has expired
    if (time() > $expiry_timestamp) {
        echo "<p>This link has expired.</p>";
        exit;
    }

    // Use the fixed 10-digit code to generate the decryption key
    $key = hash('sha256', $fixed_code);

    // Decrypt the content and PIN
    $decrypted = decryptContent($encrypted_data, $key);
    $content = $decrypted['content'];
    $pin = $decrypted['pin'];

    // If a PIN is set, prompt for PIN verification
    if ($pin) {
        if ($_POST['pin'] === $pin) {
            echo "<div class='content-container'><p>$content</p></div>";
        } else {
            echo "<div class='content-container'>
                    <h2>Enter PIN to view content:</h2>
                    <form method='POST'>
                        <input type='password' name='pin' maxlength='4' pattern='\d{4}' required />
                        <button type='submit'>Verify PIN</button>
                    </form>
                  </div>";
        }
    } else {
        echo "<div class='content-container'><p>$content</p></div>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Secure Content</title>
    <style>
        body {
            font-family: Calibri, sans-serif;
            background-color: #f7f8fa;
            margin: 0;
            padding: 0;
        }
        .content-container {
            width: 100%;
            max-width: 800px;
            margin: 50px auto;
            padding: 30px;
            background-color: white;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            box-sizing: border-box;
        }
        h2 {
            text-align: center;
            color: #333;
            font-size: 24px;
        }
        p {
            font-size: 18px;
            line-height: 1.6;
            color: #555;
            text-align: center;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 14px;
            color: #888;
        }
        form {
            display: flex;
            justify-content: center;
            flex-direction: column;
            align-items: center;
        }
        input[type="password"] {
            padding: 12px;
            margin-bottom: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
            width: 200px;
        }
        button {
            padding: 12px 20px;
            background-color: #4CAF50;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
        }
        button:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>

<div class="footer">
    <p>&copy; 2024 SecureLink Generator</p>
</div>

</body>
</html>
